<?php

	
	# General settings
	


	# login
	include 'data_connect.php';
	include 'log.php';


	
	# user rights - admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator') {
		header('Location:generaluser.php');
		exit;
	}	


	# submit form data
	function submit_settings_values() {

		$save = simplexml_object('settings.xml','e',null);
		$user_on_off = ['animations','listall']; # log values only (user preferences)
		
		foreach($user_on_off as $v)
			if(!isset($_POST[$v]))
				$_POST[$v] = 'off';

		
		#$params_pages = ['opensaved.php','pages.php'];
		#if (in_array($_POST['cphomepage'],$params_pages)) 
		
		$fname = explode('?',$_POST['cphomepage']);
		$cphome = basename($fname[0],'.php').'.php';
				
		if (isset($fname[1]))
			$_POST['cphomepage'] = $cphome.'?'.$fname[1];

		if (!is_file($cphome))
			$error = 'ERROR:cphome';	
		
				
		#settings values
		$on_off_values = ['revorder'];
		$select_values = ['sort'];
		
		
		foreach($on_off_values as $val) {
			
			if (isset($_POST[$val]))
				$v = 'on';
			else 
				$v = 'off';
			
			$save->general->$val = $v;	
		}
		
		
		foreach($select_values as $val)
			if (isset($_POST[$val]))
				$save->general->$val = $_POST[$val];
				
		
		
		if (isset($_POST['total'])) {
		
				$c = get_log()['posts'];
				$intt = $_POST['total'];
				
				if ($intt >= 0 && ctype_digit($intt)) {
					$intt = ltrim($intt,'0');
					$save->general->total = $intt;
				}
				else
					$error = 'ERROR:total';

		}
		
		
		
		if (!isset($error)) {
			
			$save->general->modified = time();
			
			#save general settings and user account			
			simplexml_object_save('settings.xml',$save,null);
			update_account($_SESSION['userID'],'set');
			
			
			$_SESSION['settingsset'] = true;
		}

		else
			$_SESSION[$error] = true;

		
		header('Location:advanced.php');
		exit();
		
		return true;
		
	}



	if (isset($_POST['submitted']))
		submit_settings_values()

?>
<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Advanced settings</title>
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php
	$cssid = '#settings';
	include 'csstheme.php';
	print '<style>'.$curval.'#settings + .dpsub:after{content:"Advanced"}</style>' 
?></head>
<body>
<?php



	# panel
	include 'mypanel.php';
	

	
	if ($xmls['revorder'] == 'on')
		$revorder = 'checked';
	else
		$revorder = '';
	
	
	# select-options
	$sortby = $xmls['sort'];
	
	if (isset($xmls['total']) && $xmls['total'] != '')
		$totalres = $xmls['total'];
	else
		$totalres = 0;
	

	# user accout info
	$acc_info = get_account($_SESSION['userID']);
	
	
	# checkboxes
	$cphomepage = $acc_info['cphomepage'] == '' ? 'opensaved.php' : $acc_info['cphomepage'];
	$anim = $acc_info['animations'] == 'off' ? '' : 'checked';
	$listall = $acc_info['listall'] == 'on' ? 'checked' : ''
	
?>
	<div class="main">
		<h1 class="set inbl"><a href="general.php" title="Back to Settings">&larr;</a> Advanced settings</h1>
		<form action="advanced.php" method="post" id="MONform">
			<div class="center-container subcontainer">
			<?php
		
			action_confirm();

			if (isset($_SESSION['usericon']))
				unset($_SESSION['usericon'])
		
			?>
			
				<div id="settingspage">
					
					
				<!-- Advanced settings -->
				
					
					<!-- Sort results --> 
					<div class="sel">
						<label for="rad-0" class="lab-5" title="Sort results by">Sort results</label><br>
						<span class="des">General sorting of posts.</span>
					</div>
					
					
					<input name="sort" type="radio" id="rad-0" class="monradio" value="time" title=""<?php if ($sortby == 'time' || $sortby == '') print ' checked' ?>>
					<label for="rad-0" title="Chronological sorting">Time</label> &nbsp;&nbsp;

					<input name="sort" type="radio" id="rad-1" class="monradio" value="alpha" title=""<?php if ($sortby == 'alpha') print ' checked' ?>>
					<label for="rad-1" title="Alphabetical sorting, based on the post title">Alpha</label> &nbsp;&nbsp;
					
					
					<div class="clear-s"></div>
					
					
					<!-- Reverse results -->
					<div class="sel">
						<label for="onoff-5" class="lab-5" title="Reverse results">Reverse results</label><br>
						<span class="des"></span>
					</div>
					<input name="revorder" type="checkbox" id="onoff-5" class="moncheck" value="on" title="" <?php print $revorder ?>>
					<label for="onoff-5" class="lab-5" title="Reverse results"></label>
					<div class="clear-l"></div>
					
					
					<!-- Total number of posts --> 
					<div class="sel">
						<label for="rad-2" class="lab-5" title="Total number of posts">Limit results in index pages</label><br>
						<span class="des">0 = no limit.</span>
					</div>
					<input name="total" type="text" id="rad-2" class="inp-7" value="<?php print $totalres ?>" title="Limit the total number of posts" placeholder="">
					
					<div class="clear"></div>
					<div class="newoptions"></div>
					<div class="clear"></div>
					
						
					<!-- Control panel home page --> 
					<div class="sel">
						<label for="homepage" class="lab-5" title="Control panel home page">Control panel home page</label><br>
						<span class="des">A page to redirect to, after you login.</span>
					</div>
					<span style="opacity:.5">monofiles/</span><input type="text" id="homepage" name="cphomepage" class="inp-76" title="Filename" value="<?php print $cphomepage ?>">
					<div class="clear"></div>	
					
					
					<!-- Remove animations --> 
					<div class="sel">
						<label for="anim" class="lab-5" title="Panel animations">Panel animations</label><br>
						<span class="des"></span>
					</div>
					<input type="checkbox" id="anim" name="animations" class="moncheck" value="on" title="Turn animations on/off" <?php print $anim ?>>
					<label for="anim" class="lab-5" title="Animations"></label>
					<div class="clear-s"></div>
					
						
					<!-- List files in uploads.php --> 
					<div class="sel">
						<label for="uploads" class="lab-5" title="List all files in uploads">Show all uploaded files</label><br>
						<span class="des">Show all file types in 'Images,' or uncheck to restrict to only those specified in the xml file.</span>
					</div>
					<input type="checkbox" id="uploads" name="listall" class="moncheck" title="List all uploaded files" value="on" <?php print $listall ?>>
					<label for="uploads" class="lab-5" title="List all files in uploads"></label>
					<div class="clear"></div>
					
					</div>
				<div class="clear"></div>
			</div>
		</form>
	</div>
</body>
</html>
