<?php 
	

	# Create or edit a page



	# login
	include 'data_connect.php';
	include 'log.php';
	


	# user rights - admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator') {
		header('Location:opensaved.php');
		exit();
	}
	

	
	function loadpage() {
		
		if (isset($_GET['savedname'])) {
			
			$savedname = $_GET['savedname'];
			$xmlfile = simplexml_object($savedname,'l','page');

			if ($xmlfile == ['falsexml'])
				return 'File has errors';
			elseif ($xmlfile == ['missingfile'])
				return 'File is missing';
			else {
				$filebase = basename($savedname,".xml");
				$htmfile = 'savedpages/'.$filebase.'.htm';
				$html_content = (is_file($htmfile)) ? file_get_contents($htmfile) : '';
				$values = ['title' => $xmlfile->pageinfo->page->title,
						   'description' =>$xmlfile->pageinfo->page->description,
						   'filename' =>$xmlfile->pageinfo->page->filename,
						   'filebase' =>$filebase,
						   'catalogue'=>$xmlfile->pageinfo->page->path,
						   'donotpub'=>$xmlfile->pageinfo->page->published,
						   'html_content' => $html_content
						  ];

				return $values;

			}
		}
	
		else {
		
			$pagebase = substr($_SESSION['userID'],0,5).'P'.bin2hex(random_bytes(6));
			$values = ['title' => '',
					   'description' => '',
					   'filename' => '',
					   'catalogue'=>'',
					   'html_content' => '',
					   'donotpub' => '',
					   'filebase' => $pagebase
					  ];
			
			return $values;
		}
	}
	
	$pageval = loadpage();

	if (!is_array($pageval)) {
		$_SESSION['ERROR'] = $pageval;
		header('Location:pages.php');
		exit();
	}

	$texteditor = get_account($_SESSION['userID'])['texteditor'];

	if (isset($_GET['showpub']))
		$g='?showpub';
	elseif(isset($_GET['showunp']))
		$g='?showunp';
	else
		$g=''


?>
<!doctype html>
<html>
<head>
<title>Page</title>
<meta charset="utf-8">
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php
	$cssid = '#allpages';
	include 'csstheme.php';
	print '<style>'.$curval.'</style>' ?>
</head>
<body>
<style>
	#allpages + .dpsub:after{content:"Page"}
	.main{left:0;position:relative;width:100%;margin-right:0;max-width:88%;margin-top:140px} 
</style>
	<?php

	include 'mypanel.php';
	
	action_confirm();


	# Do not publish checkbox
	$donotchk = $pageval['donotpub'] == 'hidden' ? 'checked' : ''

	?>
	<div class="main">
		<form action="pagepost.php" method="post" id="mainform" ></form>
		<div class="clear"></div>
		<div id="page" class="nocontent">
		<div id="action-block">
			<div id="result-block">
				<div id="resultt"></div>
			</div>
			<!-- Unique id hidden -->
			<input type="text" id="uuid" name="uniqueid" value="<?php print $pageval['filebase'] ?>" form="mainform" hidden>
			<div class="postmore">
				<span class="dot"></span>
				<span class="dot"></span>
				<span class="dot"></span>
				<div class="pmoptions">
					<button class="close-but" onclick="closeEditor();location.href='pages.php<?php print $g ?>'" type="button">Close</button>
				</div>
			</div>
			<!-- Save button -->
			<input name="button" type="button" id="sd" class="stylish-button" value="Save page" onclick="sendTopagepost();">
			<!-- Do not publish button -->
			<label for="donotpub" class="lab-5 cplab5" title="Do not publish">Do not publish</label>
			<input type="checkbox" name="pagepub" class="moncheck" id="donotpub" form="mainform" title="Do not publish" <?php print $donotchk ?>>
			<label for="donotpub" class="lab-5 dnp" title="Do not publish"></label>
		</div>
		<div class="newpageleft">
			<input type="text" name="title" class="grow" id="headline-page" form="mainform" placeholder="Title" value="<?php print $pageval['title'] ?>">
			<div id="editor-container">
			<?php
			if ($texteditor == 'on') { 
			
				include 'text-editor-controls.php';
			 	print '<div id="editor" contenteditable></div>'.PHP_EOL.'<div id="output-container" class="hide">';
			}
			 else
			 
			 	print 	'<div id="output-container">'
				
			 ?>
			 
				<textarea name="content" id="output" autocomplete="off" form="mainform"><?php

				   if (isset($pageval['html_content']))
					   print htmlspecialchars($pageval['html_content'])


				  ?></textarea>
				</div>
			</div>
			
			<div class="clear"></div>
		</div>


			<!-- Meta & info -->
			<div class="newpageright">
				<div class="clear"></div>
				<div class="clear"></div>
				<label for="metades" class="postinfo">Meta description</label>
				<textarea name="description" class="mini-editor" id="metades" form="mainform"><?php print $pageval['description'] ?></textarea>
				<div class="clear"></div>
				<label for="filename" class="postinfo">Filename</label>
				<input type="text" name="filename" id="filename" form="mainform" value="<?php print $pageval['filename'] ?>">
				<div class="clear"></div>
				<label for="catalogue" class="postinfo">Path</label>
				<span></span>
				<input type="text" name="catalogue" id="catalogue" form="mainform" value="<?php print $pageval['catalogue'] ?>" list="pages">
				<datalist id="pages">
					<?php
						
						# Get all pages
						$array_xml = $array_param = $array_path = array();
						$directory = new DirectoryIterator('savedpages/');
						
						foreach ($directory as $fileinfo) {
							
							if ($fileinfo->isFile() && substr($fileinfo->getBasename(),-4) == '.xml' && $fileinfo->getSize() > 0) {
												
								$name = $fileinfo->getBasename();
								$sp = simplexml_object($name,'l','page');
								$array_path[] = rtrim($sp->pageinfo->page->path,'/');
								
							}
							
						}
						
						
						$uarray_path = array_unique($array_path);
						
						foreach($uarray_path as $key=>$val)
							if ($val == '') {
								unset($uarray_path[$key]);
								break;
							}
								
						
						
						if (count($uarray_path) > 0) {
							
							$rearr=[];
							foreach($uarray_path as $val)
								$rearr[substr_count($val,'/')][] = $val;
							
							
							ksort($rearr);

							
							foreach($rearr as $key=>$val)
								sort($rearr[$key]);
								
							
							foreach($rearr as $key=>$val)
								foreach($val as $pagef)
									print '<option>'.$pagef.'</option>';
							
						}
						
						
						

						
								
					?>
				</datalist>
				<div class="clear-m"></div>
				
			</div>
		</div>
	</div>
	<script src="javascript/createpage.js"></script>
	<?php
	
	if ($texteditor == 'on')

		print '<script src="javascript/text-editor.js"></script>'

	?>
</body>
</html>
