<?php


	# Settings for author users



	# login
	include_once 'data_connect.php';
	include_once 'log.php';
	
	
	
	# user rights - authors only
	if (get_account($_SESSION['userID'])['rights'] == 'administrator') {
		header('Location:general.php');
		exit();
	}
	
	

	function submit_settings_values() {

		$urlicon = $_POST['urlicon'];
		
		if (strlen($_POST['usereditorname']) > 40)
			$error = 'ERROR:editorname';

		$userrelated = array('usereditorname','urlicon');
		foreach ($userrelated as $user) {
			
			if ($user == 'urlicon')
				$_POST[$user] = trim($_POST[$user]);
				
			$_POST[$user] = (isset($_POST[$user])) ? strip_tags($_POST[$user]) : ' ';

		
		}
		
		
		# personal on off settings settings
		$personal_on_off = ['texteditor'];
		
		foreach($personal_on_off as $val)
			
			if (!isset($_POST[$val]))
				$_POST[$val] = 'off';

			
		if (!isset($error)) {
			update_account($_SESSION['userID'],'set');
			$_SESSION['settingssetuser'] = true;
		}

		else
			$_SESSION[$error] = true;
		
		
		header('Location:generaluser.php');
		exit();
		
		return true;
			
	}
	
	if (isset($_POST['submitted']))
		submit_settings_values()


?>
<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Settings</title>
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php 
	$cssid = '#settings';	
	include 'csstheme.php';
	print '<style>'.$curval.'</style>' ?>
<link rel="stylesheet" type="text/css" href="cmsavebutton.css">
</head>
<body>
<?php

	

	# panel
	include 'mypanel.php';
	action_confirm();



	# user accout info
	$acc_info = get_account($_SESSION['userID']);
	$editorname = $acc_info['editorname'];
	$urlicon = $acc_info['urlicon'];
	$texteditor = $acc_info['texteditor']

?>
	
	<div class="main">
		<h1>Settings</h1>
	
		<div class="center-container">
		<?php
		

		if(isset($_SESSION['usericon']))
			unset($_SESSION['usericon']);
		
		?>
			<div id="settingspage">
			
				<form action="generaluser.php" method="post" id="MONform">
					
				
				<!-- Text editor -->
				<div class="sel">
					<label for="onoff-0" class="lab-5" title="Text/HTML editor">Text/HTML editor</label><br>
					<span class="des">An old document "wysiwyg" editor for writing posts and pages.</span>
				</div>
				<input type="checkbox" name="texteditor" value="on" id="onoff-0" class="moncheck" title="Text editor" <?php if ($texteditor == 'on') print 'checked' ?>>
				<label for="onoff-0" class="lab-5" title="Text/HTML editor"></label>
				<div class="clear"></div>
				
				
				<!-- Color theme -->
				<div class="sel">
					<span class="lab-5" style="top: 10px;position: relative" title="Control panel theme">Control panel theme</span><br>
					<span class="des"></span>
				</div>
				<div class="sel-r">
					<input name="theme" type="radio" id="rd-1" class="monradio" value="light"<?php if ($user_theme == 'light') print ' checked' ?>>
					<label for="rd-1" title="Light theme">Light</label>
					<input name="theme" type="radio" id="rd-3" class="monradio" value="dark"<?php if ($user_theme == 'cmdark') print ' checked' ?>>
					<label for="rd-3" title="Dark theme">Dark</label>
				</div>
				<div class="clear-ss"></div>
				
				
	
				<!-- Editor name-->
				<div class="sel">
					<label for="editorname" class="lab-5" title="Editor name">Editor name</label><br>
					<span class="des">Appears instead of username.</span>
				</div>
				<input name="usereditorname" type="text" id="editorname" class="inp-76" title="Editor name" value="<?php print $editorname ?>">
				<div class="clear"></div>



				<!-- User icon -->
				<div><span class="lab-5" title="User icon">Upload user icon</span><br>
					<span class="des">Upload an image file.</span>
				</div>
				
				
				<!-- Upload iframe -->
				<iframe src="upload_icon.php" name="user-image" id="user-image"></iframe>
				<div class="clear-ss"></div>
				
				
				<!-- Image file -->
					<p class="sel">
					<label for="usericon" class="lab-5" title="Image file">Image file</label><br>
					<span class="des">An image file from images folder (overrides upload user icon).</span>
					</p>
					<input id="usericon" type="text" name="urlicon" value="<?php print $urlicon ?>" class="inp-2" title="Image filename" placeholder="empty">
				<div class="clear-l"></div>
				
				
				<!-- Change login pasword -->
				<div class="sel">
					<span class="labspan" title="Login password">Login password</span><br>
					<span class="des">Create a new login password.</span>
				</div>
				<a href="password_change.php" class="setlink" title="Go to change password page">Change your log in password &rarr;</a><br>
				<div class="clear"></div>		
					
				</form>
			</div>
		</div>
	</div>
</body>
</html>
