<?php


	# Upload files
	# login
	include_once 'data_connect.php';
	include 'log.php';
	
	
	if (is_file('filesinfo/filetypes.xml')) {
	
	
		$fl = simplexml_object('filesinfo/filetypes.xml','l',null);
				
		# File types allowed for uploading
		$filetypes=[];
		foreach ($fl->files->children() as $ufile)
			$filetypes[] = (string)$ufile;
		
		$allowed = implode(' ',$filetypes);	
		
		
		# File types allowed to list
		$showfiles=[];
		foreach ($fl->show->children() as $sfile)
			$showfiles[] = (string)$sfile;

		$ftoshow = implode(' ',$showfiles);
		
	}
	
	else {
		
		#$allowed = $ftoshow = implode(' ',['jpg','png','gif']);
		
		file_put_contents('filesinfo/filetypes.xml','<?xml version="1.0" encoding="utf-8"?><uploads><title>Filetypes</title>'.PHP_EOL.'<files><f>jpg</f><f>png</f><f>gif</f></files><show><f>jpg</f><f>png</f><f>gif</f><f>svg</f></show></uploads>');
		header('Location:uploads.php');
		exit();
	}
	
	
	# upload an image file
	if (isset($_FILES['uploaded'])) {
	
		$tname = time();
		$target_path = '../images/'.basename(str_replace(' ','',$_FILES['uploaded']['name']));

		if (strpos($allowed,substr($target_path,-3)) !== false) { 
	
			$directory = new DirectoryIterator('../images/');
			foreach ($directory as $fileinfo) {
				
				if ($fileinfo->isFile()) {
					
					$name = $fileinfo->getFilename();
														
					if ($name == basename( $_FILES['uploaded']['name'])) {	
						$target_path = '../images/'.$tname.'-'.basename(str_replace(' ','',$_FILES['uploaded']['name']));
						break;
					}
				}
			}

			if (move_uploaded_file($_FILES['uploaded']['tmp_name'], $target_path)) {
			
				$_SESSION['MONimg_upload_success'] = true;
				header('Location:uploads.php');
				exit();
			}
		
			else {
		
				$_SESSION['MONimg_upload_error'] = true;
				header('Location:uploads.php');
				exit();
			}
							
		}

		else {
	
			$_SESSION['MONimg_upload_file_type'] = true;
			header('Location:uploads.php');
			exit();
		}

	}

	if (isset($_GET['delimg'])) {

		
		$img = $_GET['delimg'];
		chdir('../images');

		if (is_file($img)) {
			if (unlink($img))
				$_SESSION['MONimg_removed'] = true;
			else 
				$_SESSION['MONimg_removed_failed'] = true;
		
		}
		
		chdir('../monofiles');
		header('Location:uploads.php');
		exit();
		
	}


?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Images</title>
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php
	$cssid = '#images';
	include 'csstheme.php';
	print '<style>'.$curval.'</style>' ?>
<script type="text/javascript"> function conf(form){ return confirm('Delete file?'); }</script>
</head>
<body>
<?php
	
		
	# panel	
	include 'mypanel.php';
	action_confirm()



	?>
	<div class="main">
		<h1>Images</h1>
		<div id="main-container">
			<div style="height:30px"></div>
			
			<form id="imgform" enctype="multipart/form-data" action="uploads.php" method="POST">
				<input type="hidden" name="MAX_FILE_SIZE" value="<?php

					# The value of MAX_FILE_SIZE is the maximum filesize accepted by PHP.
					echo $xmls['maximagesize']*1000
						
				?>">
				<input name="uploaded" type="file" id="uploaded">
				<input type="submit" id="submitimage">
			</form>
			
			<!-- Results per page -->
			<div class="results-set">
				<div class="normal-res">
				<span style="font-size:12px">Results per page &nbsp;</span>
				<?php 
					pageResults('images',null)
				?>
				</div>	
			</div>
											
			<!-- Upload images -->			
			<div id="uploadedimages">
			<?php
				
				$array_img = array();
				$array_mtime = array();
				$none = '<i id="no-results">:: no files found</i>';
				
				if (is_dir('../images')) {
				
					# figure out the files to show by checking the log.xml for 'listall' option
					$allfiles = isset($acc_info['listall']) ? $acc_info['listall'] : 'off';
				 
				
					$directory = new DirectoryIterator('../images/');
					
					$catnum=0;
					foreach ($directory as $fileinfo) {
					
						if ($fileinfo->isFile()) {
				
							$name = $fileinfo->getFilename();
							$ext = $fileinfo->getExtension();
							$mtime = $fileinfo->getMtime();
								
							if ($allfiles == 'on' || strpos($ftoshow,$ext) !== false) {
								
								$array_img[]= $name;
								$array_mtime[] = $mtime;
								$catnum++;
							}
						}	
					}
					
					
					rsort($array_mtime);
					$cwd = 'images';
					include 'navinfo.php';
						
					$c=0;
					$r=0;
					
					foreach($array_mtime as $mt) {
							
						foreach($array_img as $imgkey=>$img) {

							if (filemtime('../images/'.$img) == $mt) {
								
								if ($c >= $first && $c < $last) {
								
									$r++;
							
									$im = '../images/'.$img;
									
									if (mime_content_type($im) !== false)
										$any_img = strpos(mime_content_type($im),'image/') !== false ? '<img src="'.$im.'">' : $img;
									
									
									echo '<div class="wrapper">'.PHP_EOL.' <div class="container"><a href="'.$im.'">'.$any_img.'</a></div>'.PHP_EOL.'<div class="img-options"><a class="img-delete" href="uploads.php?delimg='.$img.'&amp;max='.$ofp.'" onclick="return conf(this);"><span class="imd">[x]</span>&nbsp; Remove file</a>'.PHP_EOL.'</div></div>'.PHP_EOL;
								}			
								$c++;
								unset ($array_img[$imgkey]);
							}	
						}
					}
				if ($c == 0)
					echo $none; 

				}
				
				else
					echo $none

			?>
			</div>
			<!-- Upload images END -->
			
			
			<!-- Res nav -->
			<div id="res-nav">
			<?php 
			
			if (isset($directory))
				include 'pagenav.php'
			
			?>
			</div>
			
			
		</div>
	</div>
</body>
</html>
