<?php


		# Content loading functions
		
		
		# Preserve html tags for excerpt
		function exclose_tags($content) {


			preg_match_all('/[<][a-z]*[^\/]/',$content,$htmltags);
			preg_match_all('/[<\/][^a-z][a-z]*>/',$content,$htmlctags);
			
			$htmltags = $htmltags[0]; 
			$htmlctags = $htmlctags[0]; 
			
			$h=0;
			foreach($htmltags as $val) {
				if (substr($val,-1) != '>')
					$htmltags[$h] = rtrim($htmltags[$h]).'>';		
				$h++;
			}
			
			
			$t=0;
			foreach($htmlctags as $v) {
				$htmlctags[$t] = str_replace('/','',$v);
				$t++;
			}
			
			
			$non = ['<br>','<hr>','<img>','<input>','<meta>','<link>','<area>','<base>','<col>','<embed>','<source>','<track>','<wbr>'];
			$q=0;					
			foreach($htmltags as $val) {
				if(in_array($val,$non))
					unset($htmltags[$q]);
				$q++;
			}
			
			foreach($htmlctags as $v) {
				$pos = array_search($v,$htmltags);
				unset($htmltags[$pos]);
			}
			
			$rev = array_reverse($htmltags);
			$final='';
			foreach($rev as $tag)
				$final .= str_replace('<','</',$tag);			
						
			return $final;

		}



		
		# Cut content, used in excerpt.
		# $content=string, $excpos=int, strip|null (strip removes html tags from excerpt, null retains them) 
		function cut_content($content,$excpos,$strip='null') {
		
	
			$strln = strlen($content);
			
			if ($strln > 0) {
				
				# example
				# $content = '<div style="margin:0">This is some <b>text</b> with<span> out an hr element</span></div>';
				# $excpos = 25;
	
	
				# Prepare content
				$cstrip = str_replace(PHP_EOL,'',strip_tags($content));
				$cstrip = preg_replace('/  +/',' ',$cstrip);
				$cstrip = html_entity_decode(str_replace('&nbsp;',' ',$cstrip),ENT_HTML5);
				
				
				# Make the correct calculations
				# Get the excerpt and move +1 position forward
				$substrip = mb_substr($cstrip,0,(int)$excpos+1); #'This is some text with ou*(t)'

				# Start moving backwards and stop at a [space] or a dot (.)
				$pos = max(strrpos($substrip,' '),strrpos($substrip,'.'));
				
				# Needed correction
				$excpos = $excpos >= $pos+1 ? $pos+1 : $pos;
				
				# Final excerpt 
				$substrip = substr($substrip,0,$excpos); #'This is some text with '
				
				
				if ($strip == 'strip') {
					$exc = $substrip;
					$hellip = $cstrip != $substrip ? '&hellip; ' : '';
				}
				
				else {
					
					$exc = '';
					for ($i=(int)$excpos; $i<$strln; $i++) {
						
						# Re calculate excerpt from content
						$sub = mb_substr($content,0,$i);
						$subrev = str_replace(PHP_EOL,'',strip_tags($sub));
						$subrev = preg_replace('/  +/',' ',$subrev);
						$subrev = html_entity_decode(str_replace('&nbsp;',' ',$subrev),ENT_HTML5);
						
						# Verify that the given excerpt matches the calculated one. 
						if ($substrip == $subrev) {							
							$exc = $sub;
							break;
						}
					}
					
					
					$hellip = $cstrip != $sub ? '&hellip; ' : '';
					$exc = $exc.exclose_tags($exc);
					
				}
				
				###

				return $exc.$hellip;

			}

			else
				return false;

		}





		# Load xml string
		function load_xml($str) {
				
			if (strlen($str) > 0 )
				$str = htmlspecialchars($str,ENT_COMPAT);

			return $str;
		}




		# load html content
		function load_htm($file) {
				
			$str = '';
			if (file_exists($file)) {
					$file_contents = file_get_contents($file);
					$str = htmlspecialchars($file_contents,ENT_COMPAT);		
			}
			
			return $str;
		}
			



		# load encoded html
		function loadhtml($str) {
			
				if (strlen($str) > 0 )
					$str = str_replace('&','&amp;',htmlspecialchars_decode($str,ENT_COMPAT));
				
				return $str;
		}




		# Remove tags from string and multiple empty spaces
		function remove_tags($str) {

			if (strlen($str) > 0) {
				$str = strip_tags($str);
				$str = preg_replace('/[[:space:]]+/',' ',$str);
			}
			
			return $str;
		}



?>
